<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta content="width=device-width, initial-scale=1.0" name="viewport">
        <title>{{ website_title() }}</title>
        <link rel="icon" href="{{ URL::to(website_favicon()) }}" type="image/x-icon" />
        @include('frontend.layouts.partials.styles')
        @yield('css')
        <meta name="google-site-verification" content="wpOGVjOfBoHYkTi38yDHvOmOQVwTs8VfvcY21b8fUGw" />
   
        @foreach(head_scripts() as $head_script)
            @if($head_script->script)
                {!! $head_script->script !!}
            @endif
        @endforeach
        
        
    </head>

    <body style="background-color: #F5EFFF">
        @foreach(body_scripts() as $body_script)
            @if($body_script->script)
                {!! $body_script->script !!}
            @endif
        @endforeach

        @include('frontend.layouts.partials.header')

        @yield('front-content')

        @include('frontend.layouts.partials.footer')

        @include('frontend.layouts.partials.scripts')
        @yield('js')
    </body>
</html>
